﻿var participation =
{
    url: "",
    reportConfigurationId: 0,
    mainSection: null,
    filterSection: null,
    loadedCount: 0,
    loadConfiguation: function () {
        this.mainSection = $(".analyze-participation");
        this.filterSection = $(".v-reportFilter", this.mainSection);
        var configurationSection = $(".v-configuration", this.mainSection);
        this.reportConfigurationId = $("#ReportConfigurationId", configurationSection).val();
    },
    bindToggleEvents: function () {
        $(participation.mainSection).on("click", ".h-toggleDisplay", function (e) {
            var $t = $(this);

            var $h = $(".v-hiddenContent", $t.parents(".v-toggleContainer"));
            $h.toggle();

            if ($h.is(":visible")) {
                $t.removeClass("no-print");
                $(".fa", $t).removeClass("fa-caret-right");
                $(".fa", $t).addClass("fa-caret-down");
            }
            else {
                $t.addClass("no-print");
                $(".fa", $t).addClass("fa-caret-right");
                $(".fa", $t).removeClass("fa-caret-down");
            }
        });
    },
    bindFilter: function () {
        var filterPanel = $(".v-filter-panel", this.mainSection);

        $(".button", $(".h-statusSelector", this.filterSection)).on("click", function () {
            var $b = $(this);
            $(".button").removeClass("selected");
            $b.addClass("selected");
            var selectedVal = $b.attr("data-value");
            $("input[type=hidden]", $b.parents(".h-statusSelector")).val(selectedVal);
            $(".v-custom", this.filterSection).toggle(selectedVal == "Custom");
        });

        $(".h-datepicker", this.filterSection).datepicker();

        $(".h-applyFilter", this.filterSection).on("click", function () {
            var filter = participation.getFilter();

            if (!a4logicEditor.hasError) {
                a4.callServerMethod(a4.getSurveyAction("ApplyParticipationFilter", "Analyze"), { reportConfigurationId: participation.reportConfigurationId, filterJson: JSON.stringify(filter) },
                   function (response) {
                       participation.updateFilterStatus(filter);
                       participation.resetAllVariablesLoadedState();
                   });
            }
        });

        $(".h-resetFilter", this.filterSection).on("click", function () {
            a4.callServerMethod(a4.getSurveyAction("ResetParticipationFilter", "Analyze"), { reportConfigurationId: participation.reportConfigurationId },
               function (response) {
                   participation.clearFilter();
                   participation.updateFilterStatus(null);
                   participation.resetAllVariablesLoadedState();
               });
        });

        this.filterSection.on("click", ".h-deleteRow", function () {
            var item = $(this).closest(".v-questionEditableItem");
            a4logicEditor.replaceItemIndexes(item);
        });
    },
    resetAllVariablesLoadedState: function () {
        var $lazy = $(".v-multi-variables[data-loaded=true], .v-statistics[data-loaded=true], .v-hcChart[data-loaded=true], .h-lazyLoad");
        $lazy.addClass("no-print");
        $lazy.html(voxco.icons.getIcon("loading", "loading-icon"));
        $lazy.addClass("no-print");

        $(".h-dailyTracking-table").a4datatable("option", "ajaxParams", { "filter": JSON.stringify(currentFilter) });
        $(".h-dailyTracking-table").a4datatable("refresh");

        $(".h-devices-table").a4datatable("option", "ajaxParams", { "filter": JSON.stringify(currentFilter) });
        $(".h-devices-table").a4datatable("refresh");

        $(".h-dropOuts-table").a4datatable("option", "ajaxParams", { "filter": JSON.stringify(currentFilter) });
        $(".h-dropOuts-table").a4datatable("refresh");

        $lazy.lazyLoad();
        $lazy.data("loaded", false);
    },
    updateFilterStatus: function (filter) {
        var label = $(".v-filter-status", this.filterSection.parents(".v-filter-panel"));
        if (filter != null &&
            (filter.InterviewStatus != "All"
             || filter.DateFilterType != "None"
             || (filter.ResponsesFilter && filter.ResponsesFilter.Conditions && filter.ResponsesFilter.Conditions.length > 0))) {
            label.html(resources.Active);
        }
        else {
            label.html(resources.NoActiveFilter);
        }
    },
    getFilter: function () {
        var filter = currentFilter;
        if (!filter) filter = new Object();

        filter.InterviewStatus = $(".v-interview-status", this.filterSection).val();
        filter.DateFilterType = $(".h-statusSelector input[type=hidden]", this.filterSection).val();

        if (filter.DateFilterType == "Custom") {
            filter.StartDateFilter = $(".v-filter-date-from", this.filterSection).val();
            filter.EndDateFilter = $(".v-filter-date-to", this.filterSection).val();
        } else {
            filter.StartDateFilter = "";
            filter.EndDateFilter = "";
        }

        filter.ResponsesFilter = a4logicEditor.getLogic($(".filter-responses .v-logicEditor", this.filterSection), true);

        return filter;
    },
    clearFilter: function () {
        $(".v-interview-status", this.filterSection).val("All");

        $(".v-filter-date-from", this.filterSection).val("");
        $(".v-filter-date-to", this.filterSection).val("");

        $(".h-statusSelector .button", this.filterSection).removeClass("selected");
        $(".h-statusSelector .button[data-value='None']", this.filterSection).addClass("selected");
        $(".v-custom", this.filterSection).css("display", "none");

        $(".v-filterType", this.filterSection).hide();
        $(".v-customFilterBlock", this.filterSection).hide();
        $(".v-logicTable", this.filterSection).hide();
        $(".v-logicTable .v-logicBody tr", this.filterSection).remove();
    }
}

function loadParticipationSummary(container) {
    executeLazyLoadCall(container, "GetParticipationSummary");
}

function loadEmailDistributionStatus(container) {
    executeLazyLoadCall(container, "GetEmailDistributionStatus");
}

function loadSmsDistributionStatus(container) {
    executeLazyLoadCall(container, "GetSmsDistributionStatus");
}

function executeLazyLoadCall(container, surveyAction) {
    var $c = $(container);

    a4.callServerMethod(a4.getSurveyAction(surveyAction, "Analyze"), {}, function (result) {
        $c.html(result);
        $c.removeClass("no-print");
    });
}

$(document).ready(function () {
    // avoid attempt to initialize everything when not in participation page
    if ($(".analyze-participation").length == 0) return;

    participation.loadConfiguation();
    participation.bindToggleEvents();
    participation.bindFilter();

    //Skip logic
    a4logicEditor.initializeEditors($(".filter-responses", results.filterSection), []);
    a4logicEditor.setVariableAutoCompleteByAjax($(".filter-responses .v-logicEditor", results.filterSection));

    if ($(".analyze-participation .emptyPage").length == 0) {
        $(".h-datepicker").datepicker();

        $(".h-devices-table").a4datatable({
            displaySearchBox: false,
            displayColumnSelector: false,
            ajaxAction: a4.getSurveyAction("GetDeviceStatistics", "Analyze"),
            ajaxParams: { "filter": JSON.stringify(currentFilter) },
            columns: [
                { "Name": "DeviceType", "Title": resources.DeviceType, "Data": "DeviceTypeName" },
                { "Name": "DeviceOs", "Title": resources.OsVersion, "Data": "OsVersion" },
                { "Name": "TotalCompleted", "Title": resources.Completed, "Data": "TotalCompleted" },
                { "Name": "SurveyTotalCompleted", "Title": resources.PercentageOfTotal, "Data": "TotalCompletedPercentage", "Sortable": false },
                { "Name": "SurveySessionsCount", "Title": resources.SessionsCount, "Data": "SurveySessionsCount" },
                { "Name": "CompletionRate", "Title": resources.CompletionRate, "Data": "CompletionRate", "Sortable": false }
            ]
        });

        $(".h-dropOuts-table").a4datatable({
            displaySearchBox: false,
            displayColumnSelector: false,
            ajaxAction: a4.getSurveyAction("GetDropOutStatistics", "Analyze"),
            ajaxParams: { "filter": JSON.stringify(currentFilter) },
            columns: [
                { "Name": "LastDisplayedQuestionName", "Title": resources.Question, "Data": "DisplayedQuestionText", "Width": "80%" },
                { "Name": "Frequency", "Title": resources.DropOuts, "Data": "Frequency", "Width": "100px" },
                { "Name": "Percent", "Title": resources.Percentage, "Data": "Percent", "Width": "100px", "Sortable": false }
            ],
            footerCreated: function (event, data) {
                if (data.additionalData) {
                    $("tfoot", $(this)).remove();
                    $("table", $(this)).append("<tfoot><tr>"
                        + "<td>" + resources.Total + "</td>"
                        + "<td>" + data.additionalData["TotalDropouts"] + "</td>"
                        + "</tr></tfoot>");
                }
            }
        });

        $(".h-dailyTracking-table").a4datatable({
            displaySearchBox: false,
            displayColumnSelector: false,
            ajaxAction: a4.getSurveyAction("GetDailyTracking", "Analyze"),
            ajaxParams: { "filter": JSON.stringify(currentFilter) },
            columns: [
                { "Name": "Date", "Title": resources.Date, "Data": "Date", "Type": "date", "Width": "100px" },
                { "Name": "Completed", "Title": resources.Completed, "Data": "Completed", "Width": "100px" },
                { "Name": "CompletedPercentage", "Title": resources.PercentageOfTotal, "Data": "CompletedPercentage", "Sortable": false },
                { "Name": "Responses", "Title": resources.SessionsCount, "Data": "Responses" },
                { "Name": "CompletionRate", "Title": resources.CompletionRate, "Data": "CompletionRate", "Sortable": false }
            ]
        });

        $(".v-reportFilter").each(function () {
            var currentFilter = $(this);
            var statusSelector = $(".h-statusSelector", currentFilter);

            $(".button", statusSelector).on("click", function () {
                $(".button").removeClass("selected");
                $(this).addClass("selected");

                var selectedVal = $(this).attr("data-value");
                $("input[type=hidden]", statusSelector).val(selectedVal);

                if (selectedVal != "Custom") {
                    var form = $("form");
                    a4.appendAntiForgeryToken(form);
                    form.submit();
                }
                else {
                    $(".v-custom", currentFilter).show();
                }
            });

        });

        $(".h-lazyLoad").lazyLoad();
    }
});



